<?php
  //Rozpoczcie sesji
  session_start();
  
  //Dane dostpowe do serwera bazy danych
  $host = 'localhost';
  $baza = 'testphp';
  $uzytkownik = "php";
  $haslo = "test";

  //Funkcja logujca
  function checkPass($user, $pass)
  {
    //Umoliwienie odwoa do zmiennych globalnych
    global $host, $baza, $uzytkownik, $haslo;
    

    //Sprawdzenie dugoci przekazanych cigw
      
    //Dla kodowania jednobajtowego
    //$userNameLength = strlen($user);
    //$userPassLength = strlen($pass);
    
    //Dla kodowania utf-8 (1)
    //$userNameLength = strlen(utf8_decode($user));
    //$userPassLength = strlen(utf8_decode($pass));
    
    //Dla kodowania utf-8 (2)
    $userNameLength = mb_strlen($user, 'UTF-8');
    $userPassLength = mb_strlen($pass, 'UTF-8');

    if($userNameLength < 3 || $userNameLength > 20 ||
       $userPassLength < 6 || $userPassLength > 40){
      return 2;
    }
    
    //Nawizanie poczenia z serwerem MySQL
    $db_obj = new mysqli($host, $uzytkownik, $haslo, $baza);
    if($db_obj->connect_errno){
      //echo 'Wystpi bd podczas prby poczenia z serwerem MySQL...';
      //echo $db_obj->connect_error;
      return 1;
    }

    //Zabezpieczenie znakw specjalnych w parametrach
    $user = $db_obj->real_escape_string($user);
    $pass = $db_obj->real_escape_string($pass);
    
    //Wykonanie zapytania sprawdzajcego poprawno danych
    $query = "SELECT Haslo FROM Users WHERE Nazwa='$user' ";

    if(!$result = $db_obj->query($query)){
      //echo 'Wystpi bd: nieprawidowe zapytanie...';
      $db_obj->close();
      return 1;
    }

    //Sprawdzenie wynikw zapytania
    if($result->num_rows <> 1){
      //Brak uytkownika o wskazanej nazwie lub zbyt wiele wynikw
      $result = 2;
    }
    else{
      $row = $result->fetch_row();
      $pass_db = $row[0];
      //Wersja testowa bez kodowania hase
      //if($pass != $pass_db){
      //Wersja docelowa z kodowaniem hase
      if(crypt($pass, $pass_db) != $pass_db){
        $result = 2;
      }
      else{
        $result =  0;
      }
    }

    //Zamknicie poczenia z baz i zwrcenie wyniku
    $db_obj->close();
    return $result;
  }

  //Rozpoczcie procedur weryfikacji danych i logowania
  
  //Uytkownik jest zalogowany
  if(isset($_SESSION['zalogowany'])){
    header("Location: main.php");
  }
  //Uytkownik niezalogowany i brak parametru haslo lub user.
  else if(!isset($_POST["haslo"]) || !isset($_POST["user"])){
    if(!isset($_SESSION['komunikat'])){
      $_SESSION['komunikat'] = "Wprowad nazw i haso uytkownika:";
    }
    include('form.php');
  }
  //Uytkownik niezalogowany i ustawione parametry haslo i user
  else{
    $val = checkPass($_POST["user"], $_POST["haslo"]);
    if($val == 0){
      //Logowanie poprawne
      $_SESSION['zalogowany'] = $_POST["user"];
      header("Location: main.php");
    }
    else if($val == 1){
      //Bd serwera
      $_SESSION['komunikat'] = "Bd serwera. Zalogowanie nie byo moliwe.";
      header("Location: login.php");
    }
    else if($val == 2){
      //Niepoprawne dane logowania
      $_SESSION['komunikat'] = "Nieprawidowa nazwa lub haso uytkownika.";
      header("Location: login.php");
    }
    else{
      //Bd systemu logowania, nieprawidowa warto zwrcona przez checkPass
      $_SESSION['komunikat'] = "Bd serwera. Zalogowanie nie byo moliwe.";
      header("Location: login.php");
    }
  }
?>
